/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCCandleChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.PlotPoint;

class CandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    static final int HI_PT_INDEX = 0;
    static final int LO_PT_INDEX = 1;
    static final int OPEN_PT_INDEX = 2;
    static final int CLOSE_PT_INDEX = 3;
    static final int CANDLE_PT_ARRAY = 4;
    static final int NUM_PER_PT = 2;
    JCCandleChartFormat cf;
    PlotPoint[][][] pts;
    boolean[][] risingCandleIndex;
    MinMax xlim = new MinMax();
    MinMax ylim = new MinMax();
    Point start;
    Point end;
    Rectangle r;
    boolean useRubberBand = false;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = this.dataObject.getCandleChartFormat();
        this.holeValue = this.dataObject.holeValue;
        this.xaxis = this.dataObject.xaxis;
        this.yaxis = this.dataObject.yaxis;
        this.inverted = this.xaxis.isVertical;
        int n2 = this.seriesList.length / 4;
        if (!this.cachePlotData && n == -1) {
            if (this.pts == null) {
                this.pts = new PlotPoint[n2][][];
            }
            return;
        }
        if (n == -1 || n == 0) {
            this.xlim = new MinMax();
            this.ylim = new MinMax();
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
        this.pts = new PlotPoint[n2][][];
        this.risingCandleIndex = new boolean[n2][];
        boolean bl = this.cf.getIsComplex();
        int n3 = n == -1 ? 0 : n;
        int n4 = n == -1 ? n2 : n + 1;
        int n5 = n3;
        while (n5 < n4) {
            JCChartStyle jCChartStyle;
            this.pts[n5] = null;
            this.risingCandleIndex[n5] = null;
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                jCChartStyle = this.cf.getRisingCandleStyle(n5);
                if (jCChartStyle != null) {
                    n6 = jCChartStyle.getSymbolSize();
                }
                if ((jCChartStyle = this.cf.getFallingCandleStyle(n5)) != null) {
                    n7 = jCChartStyle.getSymbolSize();
                }
            } else {
                jCChartStyle = this.cf.getHiloStyle(n5);
                if (jCChartStyle != null) {
                    n7 = n6 = jCChartStyle.getSymbolSize();
                }
            }
            boolean bl2 = true;
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MAX_VALUE;
            int n10 = Integer.MAX_VALUE;
            int n11 = 4 * n5;
            int n12 = 0;
            while (n12 < 4) {
                ChartDataViewSeries chartDataViewSeries = this.seriesList[n11];
                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                    bl2 = false;
                    break;
                }
                n8 = Math.min(n8, chartDataViewSeries.maxXIndex());
                n8 = Math.min(n8, chartDataViewSeries.maxYIndex());
                n9 = Math.min(n9, chartDataViewSeries.getFirstPoint());
                n10 = Math.min(n10, chartDataViewSeries.getLastPoint());
                ++n12;
                ++n11;
            }
            if (bl2) {
                this.pts[n5] = new PlotPoint[n8][];
                this.risingCandleIndex[n5] = new boolean[n8];
                int n13 = n9;
                while (n13 <= n10) {
                    boolean bl3;
                    double d;
                    this.pts[n5][n13] = new PlotPoint[8];
                    int n14 = 4 * n5;
                    ChartDataViewSeries chartDataViewSeries = this.seriesList[n14++];
                    double d2 = chartDataViewSeries.getX(n13);
                    double d3 = chartDataViewSeries.getY(n13);
                    chartDataViewSeries = this.seriesList[n14++];
                    double d4 = chartDataViewSeries.getX(n13);
                    double d5 = chartDataViewSeries.getY(n13);
                    if (d3 < d5) {
                        double d6 = d2;
                        d = d3;
                        d2 = d4;
                        d3 = d5;
                        d4 = d6;
                        d5 = d;
                    }
                    chartDataViewSeries = this.seriesList[n14++];
                    double d7 = chartDataViewSeries.getX(n13);
                    double d8 = chartDataViewSeries.getY(n13);
                    chartDataViewSeries = this.seriesList[n14++];
                    double d9 = chartDataViewSeries.getX(n13);
                    double d10 = chartDataViewSeries.getY(n13);
                    this.risingCandleIndex[n5][n13] = bl3 = d8 < d10;
                    int n15 = 0;
                    d = d2;
                    double d11 = d3;
                    double d12 = bl3 ? d9 : d7;
                    double d13 = bl3 ? d10 : d8;
                    this.financialClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n13, n15, this.inverted, false);
                    n15 = 2;
                    d = d4;
                    d11 = d5;
                    d12 = bl3 ? d7 : d9;
                    d13 = bl3 ? d8 : d10;
                    this.financialClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n13, n15, this.inverted, false);
                    n15 = 4;
                    double d14 = d7;
                    double d15 = d8;
                    int n16 = this.xaxis.toPixel(d14, this.drawFront);
                    int n17 = (bl3 ? n6 : n7) / 2;
                    d = this.xaxis.toData(n16 - n17, this.drawFront);
                    d11 = d15;
                    d12 = this.xaxis.toData(n16 + n17, this.drawFront);
                    d13 = d15;
                    boolean bl4 = !(d8 > this.ylim.max && d10 > this.ylim.max || d8 < this.ylim.min && d10 < this.ylim.min);
                    this.financialClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n13, n15, this.inverted, bl4);
                    n15 = 6;
                    d14 = d9;
                    d15 = d10;
                    n16 = this.xaxis.toPixel(d14, this.drawFront);
                    d = this.xaxis.toData(n16 - n17, this.drawFront);
                    d11 = d15;
                    d12 = this.xaxis.toData(n16 + n17, this.drawFront);
                    d13 = d15;
                    this.financialClip(d, d11, d12, d13, this.xlim, this.ylim, this.pts[n5][n13], n13, n15, this.inverted, bl4);
                    ++n13;
                }
            }
            ++n5;
        }
    }

    public void draw(Graphics graphics) {
        if (this.pts == null) {
            return;
        }
        try {
            if (this.seriesList == null) {
                return;
            }
            boolean bl = this.cf.getIsComplex();
            PlotPoint plotPoint = null;
            Point point = new Point(0, 0);
            Point point2 = new Point(0, 0);
            boolean bl2 = false;
            boolean bl3 = false;
            JCFillStyle jCFillStyle = null;
            JCLineStyle jCLineStyle = null;
            int n = 0;
            while (n < this.pts.length) {
                block27: {
                    JCChartStyle jCChartStyle;
                    JCChartStyle jCChartStyle2;
                    JCChartStyle jCChartStyle3;
                    JCLineStyle jCLineStyle2;
                    block29: {
                        JCChartStyle jCChartStyle4;
                        block28: {
                            if (!this.cachePlotData) {
                                this.recalc(n);
                            }
                            if (this.pts[n] == null) break block27;
                            boolean bl4 = true;
                            int n2 = 4 * n;
                            int n3 = 0;
                            while (n3 < 4) {
                                if (!this.seriesList[n2].isShowing) {
                                    bl4 = false;
                                    break;
                                }
                                ++n3;
                                ++n2;
                            }
                            if (!bl4 || (jCChartStyle4 = this.cf.getHiloStyle(n)) == null) break block27;
                            jCLineStyle2 = jCChartStyle4.getLineStyle();
                            if (!bl) break block28;
                            jCChartStyle3 = this.cf.getRisingCandleStyle(n);
                            if (jCChartStyle3 != null && (jCChartStyle2 = this.cf.getFallingCandleStyle(n)) != null && (jCChartStyle = this.cf.getCandleOutlineStyle(n)) != null) break block29;
                            break block27;
                        }
                        jCChartStyle3 = jCChartStyle4;
                        jCChartStyle2 = jCChartStyle4;
                        jCChartStyle = jCChartStyle4;
                    }
                    int n4 = 0;
                    while (n4 < this.pts[n].length) {
                        if (this.pts[n][n4] != null) {
                            int n5;
                            int n6;
                            int n7 = 0;
                            while (n7 < 2) {
                                if (this.pts[n][n4][n7 * 2] != null) {
                                    bl2 = false;
                                    n6 = 0;
                                    while (n6 < 2) {
                                        plotPoint = this.pts[n][n4][n7 * 2 + n6];
                                        if (plotPoint == null || plotPoint.px == Integer.MAX_VALUE || plotPoint.py == Integer.MAX_VALUE) {
                                            bl2 = false;
                                        } else {
                                            point.x = plotPoint.px;
                                            point.y = plotPoint.py;
                                            if (bl2) {
                                                jCLineStyle2.draw(graphics, point2.x, point2.y, point.x, point.y);
                                            }
                                            point2.x = point.x;
                                            point2.y = point.y;
                                            bl2 = true;
                                        }
                                        ++n6;
                                    }
                                }
                                ++n7;
                            }
                            n6 = 0;
                            int n8 = Integer.MAX_VALUE;
                            int n9 = Integer.MAX_VALUE;
                            int n10 = Integer.MIN_VALUE;
                            int n11 = Integer.MIN_VALUE;
                            int n12 = 2;
                            while (n12 <= 3) {
                                if (this.pts[n][n4][n12 * 2] == null) {
                                    n6 = 1;
                                } else {
                                    n5 = 0;
                                    while (n5 < 2) {
                                        plotPoint = this.pts[n][n4][n12 * 2 + n5];
                                        if (plotPoint == null || plotPoint.px == Integer.MAX_VALUE || plotPoint.py == Integer.MAX_VALUE) {
                                            n6 = 1;
                                        } else {
                                            n8 = Math.min(n8, plotPoint.px);
                                            n10 = Math.max(n10, plotPoint.px);
                                            n9 = Math.min(n9, plotPoint.py);
                                            n11 = Math.max(n11, plotPoint.py);
                                        }
                                        ++n5;
                                    }
                                }
                                ++n12;
                            }
                            if (n6 == 0) {
                                bl3 = this.risingCandleIndex[n][n4];
                                jCFillStyle = bl3 ? jCChartStyle3.getFillStyle() : jCChartStyle2.getFillStyle();
                                jCLineStyle = jCChartStyle.getLineStyle();
                                n5 = Math.max(n10 - n8, 1);
                                int n13 = Math.max(n11 - n9, 1);
                                if (bl) {
                                    jCFillStyle.fillRect(graphics, n8, n9, n5, n13);
                                    jCLineStyle.drawRect(graphics, n8, n9, n5, n13);
                                } else {
                                    if (!bl3) {
                                        jCLineStyle.fillRect(graphics, n8, n9, n5, n13);
                                    }
                                    jCLineStyle.drawRect(graphics, n8, n9, n5, n13);
                                }
                            }
                        }
                        ++n4;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n] = null;
                        this.risingCandleIndex[n] = null;
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = Integer.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        PlotPoint plotPoint = null;
        int n5 = 0;
        while (n5 < this.pts.length) {
            if (!this.cachePlotData) {
                this.recalc(n5);
            }
            if (this.pts[n5] != null) {
                boolean bl = true;
                int n6 = 4 * n5;
                int n7 = 0;
                while (n7 < 4) {
                    if (!this.seriesList[n6].isShowing) {
                        bl = false;
                        break;
                    }
                    ++n7;
                    ++n6;
                }
                if (bl) {
                    int n8 = 0;
                    while (n8 < this.pts[n5].length) {
                        if (this.pts[n5][n8] != null) {
                            int n9 = 0;
                            while (n9 < 4) {
                                if (this.pts[n5][n8][n9 * 2] != null) {
                                    int n10 = n9 < 2 ? 1 : 2;
                                    int n11 = 0;
                                    while (n11 < n10) {
                                        plotPoint = this.pts[n5][n8][n9 * 2 + n11];
                                        if (plotPoint != null && plotPoint.px != Integer.MAX_VALUE && plotPoint.py != Integer.MAX_VALUE && plotPoint.drawPoint) {
                                            int n12 = Integer.MAX_VALUE;
                                            switch (n) {
                                                case 1: {
                                                    n12 = Math.abs(plotPoint.px - point2.x);
                                                    break;
                                                }
                                                case 2: {
                                                    n12 = Math.abs(plotPoint.py - point2.y);
                                                    break;
                                                }
                                                default: {
                                                    n12 = JCChartUtil.distance(point2.x, point2.y, plotPoint.px, plotPoint.py);
                                                }
                                            }
                                            if (n12 < n4) {
                                                n2 = n5 * 4 + n9;
                                                n3 = plotPoint.point;
                                                n4 = n12;
                                            }
                                        }
                                        ++n11;
                                    }
                                }
                                ++n9;
                            }
                        }
                        ++n8;
                    }
                    if (!this.cachePlotData) {
                        this.pts[n5] = null;
                        this.risingCandleIndex[n5] = null;
                    }
                }
            }
            ++n5;
        }
        if (n2 >= 0 && n3 >= 0) {
            jCDataIndex = new JCDataIndex(n3, this.seriesList[n2], n2);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = this.seriesList[n2];
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        int n = jCDataIndex.series.drawingOrder / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        int n2 = jCDataIndex.point;
        PlotPoint[] plotPointArray = this.pts[n][n2];
        int n3 = jCDataIndex.seriesIndex - n * 4;
        int n4 = n3 * 2;
        if (plotPointArray[n4] != null && plotPointArray[n4].px != Integer.MAX_VALUE && plotPointArray[n4].py != Integer.MAX_VALUE) {
            if (n3 > 1) {
                this.useRubberBand = true;
            }
            this.start = new Point(plotPointArray[n4].px + this.r.x, plotPointArray[n4].py + this.r.y);
            if (bl) {
                this.end = new Point(plotPointArray[n4].px + this.r.x, plotPointArray[n4 + 1].py + this.r.y);
                return;
            }
            this.end = new Point(plotPointArray[n4 + 1].px + this.r.x, plotPointArray[n4].py + this.r.y);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.xaxis.isVertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
            return;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (jCDataIndex.dataView.xaxis.isVertical) {
            return n - this.r.x;
        }
        return n2 - this.r.y;
    }

    int getNumSeriesPerData() {
        return 4;
    }
}

